package pom1.apple1;

public class Pia6820
{

    public Pia6820(Screen screen)
    {
        this.screen = screen;
        echo = System.getProperty("ECHO", "N").equalsIgnoreCase("Y");
        reset();
    }

    public void setKbdInterrups(boolean b)
    {
        kbdInterrupts = b;
    }

    public boolean getKbdInterrups()
    {
        return kbdInterrupts;
    }

    public boolean getDspOutput()
    {
        return dspOutput;
    }

    public void writeDspCr(int dspCr)
    {
        if(!dspOutput)
        {
            if(dspCr >= 128)
                dspOutput = true;
            dspCr = 0;
        } else
        {
            this.dspCr = dspCr;
        }
    }

    public void writeDsp(int dsp)
    {
        if(dsp >= 128)
            dsp -= 128;
        if(echo)
            if(dsp == 13)
                System.out.println();
            else
                System.out.print((char)dsp);
        screen.outputDsp(dsp);
        this.dsp = dsp;
    }

    public void writeKbdCr(int kbdCr)
    {
        if(!kbdInterrupts)
        {
            if(kbdCr >= 128)
            {
                kbdInterrupts = true;
                kbdCr = 0;
            }
        } else
        {
            this.kbdCr = kbdCr;
        }
    }

    public void writeKbd(int kbd)
    {
        this.kbd = kbd;
    }

    public int readDspCr()
    {
        return dspCr;
    }

    public int readDsp()
    {
        return dsp;
    }

    public int readKbdCr()
    {
      if (kbdInterrupts && kbdCr >= 0x80)
      {
        kbdCr = 0;
        readyForInput = false;
        return 0xA7;
      }
      else
      {
        readyForInput = true;
        return kbdCr;
      }
    }

    public boolean isReadyForInput()
    {
      return readyForInput;
    }

    public int readKbd()
    {
        return kbd;
    }

    public void reset()
    {
        kbdInterrupts = false;
        kbdCr = 0;
        dspOutput = false;
        dspCr = 0;
    }

    private int dspCr;
    private int dsp;
    private int kbdCr;
    private int kbd;
    private boolean kbdInterrupts;
    private boolean dspOutput;
    private Screen screen;
    private boolean echo;

    private boolean readyForInput = false;
}
